﻿//////////////////////////////////////////////
// FontUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class Font ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/BufferView.h>
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT FontUtils final
	{
		public :

			// System queries
			static nkMemory::BufferCast<nkMemory::String> getAvailableFontFaces (System* system = nullptr) ;
			static nkMemory::BufferCast<unsigned int> getCharactersWidth (nkMemory::BufferView<char> characters, Font* font = nullptr, System* system = nullptr) ;

		private :

			// Constructor, destructor
			FontUtils () = delete ;
			~FontUtils () = delete ;
	} ;
}